#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2021/9/3 14:44
# @Author : Opfer
# @Site :
# @File : priority_control.py
# @Software: PyCharm

from equipment.truck import *
from equipment.dump import *
from equipment.excavator import *
from para_config import *


class PriorityController():

    def __init__(self, dump, excavator, truck):
        # 设备类
        self.dump = dump
        self.excavator = excavator
        self.truck = truck

    def weighted_walk_cost(self):
        dynamic_dump_num = get_value("dynamic_dump_num")
        dynamic_excavator_num = get_value("dynamic_excavator_num")
        dynamic_dump_set = get_value("dynamic_dump_set")
        dynamic_excavator_set = get_value("dynamic_excavator_set")
        walk_weight = np.ones((dynamic_dump_num, dynamic_excavator_num))
        excavator_priority = self.excavator.excavator_priority_coefficient
        excavator_material_priority = self.excavator.excavator_material_priority
        dump_priority = self.dump.dump_priority_coefficient
        dump_material_priority = np.ones(dynamic_dump_num)
        park_walk_weight = np.ones((park_num, dynamic_excavator_num))

        rule6 = session_mysql.query(DispatchRule).filter_by(id=6).first()

        if not rule6.disabled:
            for dump_id in dynamic_dump_set:
                for excavator_id in dynamic_excavator_set:
                    dump_index = self.dump.dump_uuid_to_index_dict[dump_id]
                    excavator_inedx = self.excavator.excavator_uuid_to_index_dict[excavator_id]
                    walk_weight[dump_index][excavator_inedx] += dump_priority[dump_index] * \
                                                                excavator_priority[excavator_inedx]
            park_walk_weight = park_walk_weight * self.excavator.excavator_priority_coefficient

        rule7 = session_mysql.query(DispatchRule).filter_by(id=7).first()

        if not rule7.disabled:
            for dump_id in dynamic_dump_set:
                for excavator_id in dynamic_excavator_set:
                    dump_index = self.dump.dump_uuid_to_index_dict[dump_id]
                    excavator_inedx = self.excavator.excavator_uuid_to_index_dict[excavator_id]
                    walk_weight[dump_index][excavator_inedx] += dump_material_priority[dump_index] * \
                                                                excavator_material_priority[excavator_inedx]
            park_walk_weight = park_walk_weight * self.excavator.excavator_material_priority

        walk_weight = walk_weight - (walk_weight.min() - 1)

        park_walk_weight = park_walk_weight - (park_walk_weight.min() - 1)

        return walk_weight, park_walk_weight

    def available_walk(self):
        dynamic_dump_num = get_value("dynamic_dump_num")
        dynamic_excavator_num = get_value("dynamic_excavator_num")
        dynamic_dump_set = get_value("dynamic_dump_set")
        dynamic_excavator_set = get_value("dynamic_excavator_set")
        walk_weight = np.zeros((dynamic_dump_num, dynamic_excavator_num))

        for dump_id in dynamic_dump_set:
            for excavator_id in dynamic_excavator_set:
                dump_index = self.dump.dump_uuid_to_index_dict[dump_id]
                excavator_inedx = self.excavator.excavator_uuid_to_index_dict[excavator_id]
                if self.excavator.excavator_material[excavator_id] != self.dump.dump_material[dump_id]:
                    walk_weight[dump_index][excavator_inedx] += 1000000

        return walk_weight

    def update_group_walk_available(self):
        group_walk_available = np.full((get_value("dynamic_dump_num"), get_value("dynamic_excavator_num")), 1000000)

        for dump_id in get_value("dynamic_dump_set"):
            for excavator_id in get_value("dynamic_excavator_set"):
                item = session_mysql.query(Dispatch).filter_by(dump_id=dump_id, exactor_id=excavator_id, isauto=1,
                                                               isdeleted=0).first()
                if item is not None:
                    dump_index = self.dump.dump_uuid_to_index_dict[dump_id]
                    excavator_index = self.excavator.excavator_uuid_to_index_dict[excavator_id]
                    group_walk_available[dump_index][excavator_index] = 0

        return group_walk_available
