#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2022/5/30 15:35
# @Author : Opfer
# @Site :
# @File : group.py    
# @Software: PyCharm

from data.dispatchInfo import DispatchInfo
from bidict import bidict
from alg.algorithm import AlgorithmBase


class Group:
    """
    class for group instance.
    """
    def __init__(self, group_id):
        """ Generate a group obj.
        :param group_id: (uuid) group_id
        """

        self.group_id = group_id

        # group devices
        self.excavator_dict = {}    # excavator_id -> unload_area_id
        self.dump_dict = {}    # dump_id -> load_area_id
        self.truck_set = set()    # truck_id

        # road network info.
        self.to_excavator_distance = None
        self.to_dump_distance = None
        self.park_to_excavator_distance = None

        self.to_excavator_congestion = None
        self.to_dump_congestion = None
        self.park_to_excavator_congestion = None

        # device map
        self.truck_uuid_index_dict = bidict()
        self.excavator_uuid_index_dict = bidict()
        self.dump_uuid_index_dict = bidict()

    def update_xx_(self):
        """
        update above parameters.
        :return:
        """
        pass

    def group_dispatch(self, solver):
        """
        Receive a alg obj. and output dispatch plan for trucks in this group.
        :param solver:
        :return:
            dispatch plan: Dict({truck_id: match_id})
        """
        assert isinstance(solver, AlgorithmBase)
        s = solver(self)    # algorithm init
        return s.solve()    # algorithm solve
