
function drawScenesResultTable(teamId) {

    $(document).ready(function() {
        var myTable = $('#realTime').DataTable({
            "processing": false, //DataTables载入数据时，是否显示‘进度’提示
            "stateSave": true, //是否打开客户端状态记录功能,此功能在ajax刷新纪录的时候不会将个性化设定回复为初始化状态
            "scrollCollapse": true, //是否开启DataTables的高度自适应，当数据条数不够分页数据条数的时候，插件高度是否随数据条数而改变
            "paginationType": "full_numbers", //详细分页组，可以支持直接跳转到某页
            "language": lang, //提示信息
            "autoWidth": true, //自适应宽度，
            "lengthMenu": [8, 30, 50],
            "stripeClasses": ["odd", "even"], //为奇偶行加上样式，兼容不支持CSS伪类的场合
            "showRowNumber":true,
            "searching": false, //是否允许Datatables开启本地搜索
            "paging": false, //是否开启本地分页
            "lengthChange": false, //是否允许产品改变表格每页显示的记录数
            "info": false, //控制是否显示表格左下角的信息
            //跟数组下标一样，第一列从0开始，这里表格初始化时，第四列默认降序
            "ordering": false,
            "deferRender": true, //延迟渲染
            //"ajax":"json/device.json",
            "ajax": {
                url : url +'/scenesResults',
                type : 'get',
                data:{
                    "currentPage":1,
                    "pageSize":7,
                    "count":7,
                    "teamId":teamId,
                },
                dataType : 'json',
                beforeSend: function(request) {
                    request.setRequestHeader("accessToken", accessToken);
                },
                success : function(data) {
                    if(data['code'] == 1){
                        if(data.result.length != 0)
                            $('#realTime').dataTable().fnAddData(data.result);
                        else
                            $('#realTime').dataTable().fnClearTable();
                    }else{
						ifajax(data);
					}
                }
            }, //数据的路径 "http://192.168.5.133:8081/ic-iot/admin/'+adminId+'/devices" /"json/device.json"

            "columns": [{
                "data":"stadiumName",
                "sTitle":"赛场",
                "sDefaultContent": "",
            },{
                "data":"scenesName",
                "sTitle":"场景",
                "sDefaultContent": "",
            },{
                "data": function(obj) {
                    return '<span style="color:red">'+obj.scenesResult+'分</span>';
                },
                "sTitle": "得分情况", //标题
                "sType": 'chinese',
                "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错
            },{
                "data": function(obj) {
                    return replaceHourTime(obj.createTime / 1000);
                },
                "sTitle": "实时时间", //标题
                "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错
            }]
        });
    });
}


