var table;
$(document).ready(function() {
	table  = $('#example').DataTable({
	  "processing": false, //DataTables载入数据时，是否显示‘进度’提示  
      "stateSave": true, //是否打开客户端状态记录功能,此功能在ajax刷新纪录的时候不会将个性化设定回复为初始化状态  
      "scrollCollapse": true, //是否开启DataTables的高度自适应，当数据条数不够分页数据条数的时候，插件高度是否随数据条数而改变  
      "paginationType": "full_numbers", //详细分页组，可以支持直接跳转到某页  
      "autoWidth": false, //自适应宽度，
      "language": lang, //提示信息
      "lengthMenu": [15, 30, 50],
      "stripeClasses": ["odd", "even"], //为奇偶行加上样式，兼容不支持CSS伪类的场合
      "showRowNumber":true,
      "searching": false, //是否允许Datatables开启本地搜索
      "serverSide": true,  //启用服务器端分页
      "paging": true, //是否开启本地分页
      "lengthChange": false, //是否允许产品改变表格每页显示的记录数
      "info": true, //控制是否显示表格左下角的信息
      //跟数组下标一样，第一列从0开始，这里表格初始化时，第四列默认降序
      "order": [0, 'asc'], //asc升序   desc降序 
      "aoColumnDefs": [{
        "orderable": false,
        "aTargets": [1,2,3,4,5,6] // 指定列不参与排序
      }],
      "deferRender": true, //延迟渲染
      //"ajax":"json/device.json",
      "ajax": {
      	url : url+'companys/all',
		type : 'get',
		dataType : 'json',
		data:function ( d ) {  
            var companyName = $("#companyName").val();
            //添加额外的参数传给服务器  
            d.companyName = companyName;  
        }, 
		beforeSend: function(request) {
            request.setRequestHeader("accessToken", accessToken);
       },
      },
       "columns": [{ //定义列
        "data":"riwso",
        "render":function(data, type, full, meta ){
        	return (meta.row+1);
        },
        "sTitle": "序号", //标题
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      }, {
        "data": "companyName",
        "sTitle": "公司名称", //标题
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      }, {
        "data": "companyPhone",
        "sTitle": "公司电话", //标题
        "sType": 'chinese',
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      }, {
        "data": "companyAddress",
        "sTitle": "公司地址", //标题
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      }, {
        "data": "companyContact",
        "sTitle": "公司联系人", //标题//标题
       
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      },{
        "data":"companyEmail",
        "sTitle": "公司邮箱", //标题
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      }, {
        "data": function(obj) {
           return replaceTime(obj.createTime / 1000)+'<span type="checkbox" hidden="hidden" id=' + obj.deviceId + '></span>';
        },
        "sTitle": "创建时间", //标题
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      }/*, {
        "data": function(obj) {
        	var companyId = obj.companyId;
         	return '<span  title="查看" onclick=javascrtpt:See('+companyId+'); class="handle-btn handle-btn-edit"><i class="iconfont icon-xiangqing"></i></span>';
		},
        "className": "td-handle",
        "sTitle": "操作", //标题
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      }*/]
    });

});
  //查看
function See(companyId){
	window.open('blank-page.html?companyId='+companyId);
}

function btn(){  
    table.ajax.reload();  
} 