
$(document).ready(function() {
	  var myTable = $('#achievement').DataTable({
     "processing": false, //DataTables载入数据时，是否显示‘进度’提示  
	  "stateSave": true, //是否打开客户端状态记录功能,此功能在ajax刷新纪录的时候不会将个性化设定回复为初始化状态  
	  "scrollCollapse": true, //是否开启DataTables的高度自适应，当数据条数不够分页数据条数的时候，插件高度是否随数据条数而改变  
	  "paginationType": "full_numbers", //详细分页组，可以支持直接跳转到某页  
	  "language": lang, //提示信息
	  "destroy":true,//Cannot reinitialise DataTable,解决重新加载表格内容问题  
	  "autoWidth": true, //自适应宽度，
	  "lengthMenu": [8, 30, 50],
	  "stripeClasses": ["odd", "even"], //为奇偶行加上样式，兼容不支持CSS伪类的场合
	  "showRowNumber":true,
	  "searching": false, //是否允许Datatables开启本地搜索
	  "paging": false, //是否开启本地分页
	  "lengthChange": false, //是否允许产品改变表格每页显示的记录数
	  "info": false, //控制是否显示表格左下角的信息
     "ordering": false,
      "deferRender": true, //延迟渲染
      //"ajax":"json/device.json",
      "ajax": {
      	url : url +'/users/'+adminId+'/stadiumResults',//
				type : 'get',
				data:{
					"currentPage":1,
					"pageSize":15,
				},
				dataType : 'json',
				beforeSend: function(request) {
		            request.setRequestHeader("accessToken", accessToken);
		        },
				success : function(data) {
					if(data['code'] == 1){
						if(data.result.length != 0)
							$('#achievement').dataTable().fnAddData(data.result);
						else
							$('#achievement').dataTable().fnClearTable();
					}else{
						ifajax(data);
					}
				}
		  }, //数据的路径 "http://192.168.5.133:8081/ic-iot/admin/'+adminId+'/devices" /"json/device.json"
		     
      "columns": [{ //定义列
        "data":"riwso",
        "render":function(data, type, full, meta ){
        	return (meta.row+1);
        },
        "sTitle": "排名", //标题
        "width":"30px",
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      },{
        "data": function(obj){
        	//var sceneId = getOption("sceneId",obj.sceneId);
        	return '<a href="Exhibition.html?teamId=' + obj.teamId + '" target="_blank" style="color:#1aa79d; text-decoration:none;"><b>' + obj.teamName + '</b></a>';

        },
        "sTitle": "车队", //标题
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      }, {
      	"data":"teamOrganization",
      	"sTitle":"单位",
      	"sDefaultContent": "", 
      },{
        "data": function(obj) {
            return obj.totalScore;
        },
        "sTitle": "成绩", //标题
        "sType": 'chinese',
         "width":"30px",
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      }]
    });
});

