var table; 
$(document).ready(function() {
	table  = $('#example').DataTable({
	  "processing": false, //DataTables载入数据时，是否显示‘进度’提示  
      "stateSave": true, //是否打开客户端状态记录功能,此功能在ajax刷新纪录的时候不会将个性化设定回复为初始化状态  
      "scrollCollapse": true, //是否开启DataTables的高度自适应，当数据条数不够分页数据条数的时候，插件高度是否随数据条数而改变  
      "paginationType": "full_numbers", //详细分页组，可以支持直接跳转到某页  
      "autoWidth": false, //自适应宽度，
      "language": lang, //提示信息
      "lengthMenu": [15, 30, 50],
      "stripeClasses": ["odd", "even"], //为奇偶行加上样式，兼容不支持CSS伪类的场合
      "showRowNumber":true,
      "searching": false, //是否允许Datatables开启本地搜索
      "paging": true, //是否开启本地分页
      "serverSide": false,  //启用服务器端分页
      "iDisplayLength": 10,
      "lengthChange": false, //是否允许产品改变表格每页显示的记录数
      "info": true, //控制是否显示表格左下角的信息
      //跟数组下标一样，第一列从0开始，这里表格初始化时，第四列默认降序
      "order": [2, 'asc'], //asc升序   desc降序 
      "aoColumnDefs": [{
        "orderable": false,
        "aTargets": [0,1,3] // 指定列不参与排序
      }],
      "deferRender": true, //延迟渲染
      //"ajax":"json/device.json",
      "ajax": {
      	url : url+'users/'+adminId+'/devices/devicesBasic',
			type : 'get',
			dataType : 'json',
			data:function ( d ) {  
                var keyWord = $("#keyWord").val();
                //添加额外的参数传给服务器  
                d.keyWord = keyWord;  
	        },  
			beforeSend: function(request) {
	            request.setRequestHeader("accessToken", accessToken);
	       },
	       success : function(data) {
				if(data['code'] == 1){
					if(data.result.length != 0)
						$('#example').dataTable().fnAddData(data.result);
					else
						$('#example').dataTable().fnClearTable();
				}else{
					ifajax(data);
				}
			}
      }, //数据的路径 "http://192.168.5.133:8081/ic-iot/admin/'+adminId+'/devices" /"json/device.json"
     
      "columns": [{
        "data": function(obj){
        	//var sceneId = getOption("sceneId",obj.sceneId);
        	return /*'['+sceneId+']'+*/obj.deviceName+'<span type="checkbox" hidden="hidden" id=' + obj.deviceId + '></span>';
        },
        "sTitle": "设备名称", //标题
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      },{
      	"data":"deviceNo",
      	"sTitle":"设备编号",
      	"sDefaultContent": "", 
      },{
        "data": function(obj) {
           return replaceTime(obj.createTime / 1000);
        },
        "sTitle": "创建时间", //标题
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      }, {
        "data": function(obj) {
        	var deviceBasicId = obj.deviceBasicId;
            return '<span  title="查看" onclick=javascrtpt:See('+deviceBasicId+'); class="handle-btn handle-btn-edit"><i class="iconfont icon-xiangqing"></i></span>';
        },
        "className": "td-handle",
        "sTitle": "操作", //标题
        "sDefaultContent": "", //此列默认值为""，以防数据中没有此值，DataTables加载数据的时候报错  
      }]
    });


	 
});
  //查看
function See(deviceBasicId){
	window.open('blank-page.html?deviceBasicId='+deviceBasicId);
}

function btn(){  
    table.ajax.reload();  
} 
