import {formatDate} from '../../components/date.js';

export const editInlineAndCellColumn = [
    {
        title: '序号',
        type: 'index',
        width: 80,
        align: 'center'
    },
    {
        title: '设备名称',
        align: 'center',
        key: 'deviceName',
        width: 160,
        editable: true
    },
    {
        title: '创建时间',
        align: 'center',
        key : 'createTime',
        render: function (h, params) {  
            return h('div',   
            	formatDate(new Date(this.row.createTime), 'yyyy-MM-dd hh:mm')
            );
        }  
    },
    {
        title: '车队名称',
        align: 'center',
        width: 200,
        key: 'teamName',
        editable: true
    },
    {
        title: '设备状态',
        align: 'center',
        width: 200,
        key: 'deviceState',
        render: function () {  
            if(this.row.deviceState){
        		return '开启';
        	}else{
        		return '关闭'
        	}  
            	
        }  
    },
    {
        title: '操作',
        align: 'center',
        width: 300,
        key: 'handle',
        handle: ['close', 'unbund', 'delete']
    }
];

const tableData = {
    editInlineAndCellColumn: editInlineAndCellColumn,
};


export default tableData;
