import Main from '@/views/Main.vue';

// 不作为Main组件的子页面展示的页面单独写，如下
export const loginRouter = {
    path: '/login',
    name: 'login',
    meta: {
        title: 'Login - 登录'
    },
    component: resolve => { require(['@/views/login.vue'], resolve); }
};

export const page404 = {
    path: '/*',
    name: 'error-404',
    meta: {
        title: '404-页面不存在'
    },
    component: resolve => { require(['@/views/error-page/404.vue'], resolve); }
};

export const page403 = {
    path: '/403',
    meta: {
        title: '403-权限不足'
    },
    name: 'error-403',
    component: resolve => { require(['@//views/error-page/403.vue'], resolve); }
};

export const page500 = {
    path: '/500',
    meta: {
        title: '500-服务端错误'
    },
    name: 'error-500',
    component: resolve => { require(['@/views/error-page/500.vue'], resolve); }
};


export const locking = {
    path: '/locking',
    name: 'locking',
    component: resolve => { require(['@/views/main-components/lockscreen/components/locking-page.vue'], resolve); }
};

// 作为Main组件的子页面展示但是不在左侧菜单显示的路由写在otherRouter里
export const otherRouter = {
    path: '/',
    name: 'otherRouter',
    redirect: '/actually',
    component: Main,
    children: [
       // { path: 'actually', title: {i18n: 'home'}, name: 'home_index', component: resolve => { require(['@/views/actually/actually.vue'], resolve); } },
        { path: 'ownspace', title: '个人中心', name: 'ownspace_index', component: resolve => { require(['@/views/own-space/own-space.vue'], resolve); } },
        { path: 'message', title: '消息中心', name: 'message_index', component: resolve => { require(['@/views/message/message.vue'], resolve); } },
     	{ path: 'fault_detail', title: '场景详情', name: 'fault_detail', component: resolve => { require(['@/views/fault/fault_detail.vue'], resolve); } },
    	{ path: 'partDetali', title: '车队详情', name: 'partDetali', component: resolve => { require(['@/views/match/participating-teams/partDetali.vue'], resolve); } },
    	{ path: 'achievement', title: '测评分析', name: 'achievement_index', component: resolve => { require(['@/views/achievement/achievement.vue'], resolve); } },
     	{ path: 'illegal', title: '违规信息', name: 'illegal_index', component: resolve => { require(['@/views/actually/illegal.vue'], resolve); } },
     	{ path: 'achievement_detail', title: '详情分析', name: 'achievement_detail', component: resolve => { require(['@/views/achievement/achievement_detail.vue'], resolve); } },
     	{ path: 'achievement_edit', title: '编辑修改', name: 'achievement_edit', component: resolve => { require(['@/views/achievement/achievement_edit.vue'], resolve); } },
     	{ path: 'court_detail', title: '等级详情', name: 'court_detail', component: resolve => { require(['@/views/court/court_detail.vue'], resolve); } },
     	{ path: 'device_tool', title: '设备列表', name: 'device', component: resolve => { require(['@/views/device/device.vue'], resolve); } },
    	{ path: 'SceneEditorDetail', title: '编辑场景', name: 'SceneEditorDetail', component: resolve => { require(['@/views/court/SceneEditorDetail.vue'], resolve); } },
    	{ path: 'applyData', title: '申请详情', name: 'applyData', component: resolve => { require(['@/views/apply/applyDetali.vue'], resolve); } },
    	{ path: 'permissions_detail', title: '规定详情', name: 'permissions_detail', component: resolve => { require(['@/views/basics/permissions/permissions_detail.vue'], resolve); } },
    ]
};

// 作为Main组件的子页面展示并且在左侧菜单显示的路由写在appRouter里
export const appRouter = [
    {
        path: '/actually',
        icon: 'home',
        title: '首页',
        name: 'actually',
        component: Main,
        children: [
            { path: 'index', title: '首页', name: 'home_index', component: resolve => { require(['@/views/actually/actually.vue'], resolve); } }
        ]
    },
    {
        path: '/court',
        icon: 'lock-combination',
        title: '测评等级',
        name: 'court',
        component: Main,
        children: [
            { path: 'index', title: '测评等级', name: 'court_index', component: resolve => { require(['@/views/court/court.vue'], resolve); } }
        ]
    },
    {
        path: '/match',
        icon: 'model-s',
        name: 'match',
        title: '测评车型',
        component: Main,
        children: [
           // { path: 'court', title: '赛场管理',  name: 'court',  component: resolve => { require(['@/views/match/court/court.vue'], resolve); } },
            { path: 'participating-teams', title: '测评车型', name: 'participating-teams', component: resolve => { require(['@/views/match/participating-teams/participating-teams.vue'], resolve); } },
			//{ path: 'fault', title: '比赛场景', name: 'fault', component: resolve => { require(['@/views/match/fault/fault.vue'], resolve); } },
           // { path: 'referee', title: '打分裁判', name: 'referee', component: resolve => { require(['@/views/match/referee/referee.vue'], resolve); } }
        ]
    },
    {
        path: '/fault',
        icon: 'levels',
        name: 'fault',
        title: '测评场景',
        component: Main,
        children: [
            { path: 'fault', title: '场景管理', name: 'fault_index',  component: resolve => { require(['@/views/fault/fault.vue'], resolve); } },
			{ path: 'permissions', title: '布置规定',  name: 'permissions', component: resolve => { require(['@/views/basics/permissions/permissions.vue'], resolve); } },
        ]
    },
    {
        path: '/tool',
        icon: 'android-options',
        name: 'tool',
        title: '测评工具',
        component: Main,                                          
        children: [ 
        	{ path: 'index', title: '测评工具', name: 'tool_index',  component: resolve => { require(['@/views/device/tool.vue'], resolve); } },
        ]
    },
    {
        path: '/achievement',
        icon: 'android-options',
        name: 'achievement',
        title: '测评分析',
        component: Main,                                          
        children: [ 
        	{ path: 'index', title: '测评分析', name: 'achievement_index',  component: resolve => { require(['@/views/achievement/achievement.vue'], resolve); } },
        ]
    },
    {
        path: '/apply',
        icon: 'lock-combination',
        name: 'apply',
        title: '申请管理',
        component: Main,                                          
        children: [ 
        	{ path: 'index', title: '申请管理', name: 'apply_index',  component: resolve => { require(['@/views/apply/apply.vue'], resolve); } },
        ]
    },
    {
        path: '/users',
        icon: 'ios-person',
        name: 'users',
        title: '用户信息',
        component: Main,                                          
        children: [ 
        	{ path: 'index', title: '用户信息', name: 'users_index',  component: resolve => { require(['@/views/users/users.vue'], resolve); } },
        ]
    },
    {
        path: '/access',
        icon: 'key',
        name: 'access',
        title: '权限管理',
        access: 2,
        component: Main,
        children: [
            { path: 'index', title: '权限管理', name: 'access_index',  access: 0, component: resolve => { require(['@/views/access/access.vue'], resolve); } }
        ]
    },
    /*{
        path: '/tables',
        icon: 'ios-grid-view',
        name: 'tables',
        title: '表格',
        component: Main,
        children: [
            { path: 'dragableTable', title: '可拖拽排序', name: 'dragable-table', icon: 'arrow-move', component: resolve => { require(['@/views/tables/dragable-table.vue'], resolve); } },
            { path: 'editableTable', title: '可编辑表格', name: 'editable-table', icon: 'edit', component: resolve => { require(['@/views/tables/editable-table.vue'], resolve); } },
            { path: 'searchableTable', title: '可搜索表格', name: 'searchable-table', icon: 'search', component: resolve => { require(['@/views/tables/searchable-table.vue'], resolve); } },
            { path: 'exportableTable', title: '表格导出数据', name: 'exportable-table', icon: 'code-download', component: resolve => { require(['@/views/tables/exportable-table.vue'], resolve); } },
            { path: 'table2image', title: '表格转图片', name: 'table-to-image', icon: 'images', component: resolve => { require(['@/views/tables/table-to-image.vue'], resolve); } }
        ]
    },*/
    {
        path: '/access-test',
        icon: 'lock-combination',
        title: '权限测试页',
        name: 'accesstest',
        access: 2,
        component: Main,
        children: [
            { path: 'index', title: '权限测试页', name: 'accesstest_index', access: 0, component: resolve => { require(['@/views/access/access-test.vue'], resolve); } }
        ]
    },
    {
        path: '/international',
        icon: 'earth',
        title: {i18n: 'international'},
        name: 'international',
        access: 2,
        component: Main,
        children: [
            { path: 'index', title: {i18n: 'international'}, name: 'international_index', access: 0, component: resolve => { require(['@/views/international/international.vue'], resolve); } }
        ]
    },
    {
        path: '/basics',
        icon: 'levels',
        name: 'basics',
        title: '基础数据',
        access: 2,
        component: Main,
        children: [
            { path: 'user', title: '角色管理', name: 'user',  component: resolve => { require(['@/views/basics/user/user.vue'], resolve); } },
			{ path: 'permissions', title: '权限管理', access: 2, name: 'permissions', component: resolve => { require(['@/views/basics/permissions/permissions.vue'], resolve); } },
        ]
    },
];

// 所有上面定义的路由都要写在下面的routers里
export const routers = [
    loginRouter,
    otherRouter,
    locking,
    ...appRouter,
    page500,
    page403,
    page404
];
