import {formatDate} from '../components/date.js';

export const editInlineAndCellColumn = [
    {
        title: '序号',
        type: 'index',
        width: 80,
        align: 'center'
    },
    {
        title: '用户名',
        align: 'center',
        key: 'refereeName',
        editable: true
    },
    {
        title: '用户手机号',
        align: 'center',
        key: 'refereePhone',
        editable: true
    },
    {
        title: '用户编号',
        align: 'center',
        key: 'refereeNo',
        editable: true
    },
    {
        title: '角色',
        align: 'center',
        key: 'deviceState',
        render: function (e) {  
            if(this.row.refereeRole=="1"){
        		return '裁判员';
        	}
            if(this.row.refereeRole=="0"){
        		return '管理员';
        	}
            if(this.row.refereeRole=="2"){
        		return '普通用户';
        	}
        }  
    },
    {
        title: '操作',
        align: 'center',
        width: 200,
        key: 'handle',
        handle: ['edit','delete']
    }
];

const tableData = {
    editInlineAndCellColumn: editInlineAndCellColumn,
};


export default tableData;
