
import {replaceTime,formatDate} from '../components/date.js';
export const editInlineAndCellColumn = [
    {
        title: '序号',
        type: 'index',
        width: 80,
        align: 'center'
    },
    {
        title: '公司名称',
        align: 'center',
        key: 'companyName'
    },
    {
        title: '申请时间',
        align: 'center',
        width: 200,
        key: 'createTime',
        render: function (h, params) { 
        	if(this.row.createTime){
        		return h('div',   
            	replaceTime(this.row.createTime/1000)
            );
        	}else{
        		return ''
        	}
        
        }  
    },
    {
        title: '联系人',
        align: 'center',
        key: 'principal'
    },
    {
        title: '联系方式',
        align: 'center',
        key: 'phone'
    },
    {
        title: '申请车型',
        align: 'center',
        key: 'teamName'
    },
    {
        title: '申请等级',
        align: 'center',
        key: 'stadiumName'
    },
    {
        title: '操作',
        align: 'center',
        width: 200,
        key: 'handle',
        handle: ['detail','delete']
    }
];

const tableData = {
    editInlineAndCellColumn: editInlineAndCellColumn,
};


export default tableData;
