import {formatDate} from '../components/date.js';

export const editInlineAndCellColumn = [
    {
        title: '序号',
        type: 'index',
        width: 80,
        align: 'center'
    },
    {
        title: '比赛车辆',
        align: 'center',
        key: 'teamName'
    },
    {
        title: '违规原因',
        align: 'center',
        key: 'illegalReason',
        render:function(){
        	return this.row.illegalReason
        }
    },
    {
        title: '违规时间',
        align: 'center',
        key : 'createTime',
        render: function (h, params) {  
            return h('div',   
            	formatDate(new Date(this.row.createTime), 'yyyy-MM-dd hh:mm')
            );
        }  
    }
];
export const editInlineData = [
    {
        teamName: '交通号',
        illegalReason: '闯红灯',
        createTime: '2017-11-21'
    },
    {
        teamName: '红旗三号',
        illegalReason: '不按指示灯行驶',
        createTime: '2017-11-22'
    },
    {
        teamName: '天龙一号',
        illegalReason: '压线',
        createTime: '2017-11-23'
    }
];
const tableData = {
	editInlineData:editInlineData,
    editInlineAndCellColumn: editInlineAndCellColumn,
};


export default tableData;
