import {formatDate} from '../components/date.js';

export const editInlineAndCellColumn = [
	{
        title: '序号',
        type: 'index',
        width: 80,
        align: 'center'
    },
    {
        title: '比赛车辆',
        align: 'center',
        key: 'teamName'
    },
    {
        title: '场景',
        align: 'center',
        key: 'scenesType',
        render: function (e) {  
            if(this.row.scenesType){
        		return '路段';
        	}else{
        		return '场景'
        	}  
        }  
    },
    {
        title: '得分情况',
        align: 'center',
        key: 'scenesScore',
        render:function(){
        	return this.row.scenesScore +"分"
        }
    },
     {
        title: '实时时间',
        align: 'center',
        key : 'createTime',
        render: function (h, params) {  
            return h('div',   
            	formatDate(new Date(this.row.createTime), 'yyyy-MM-dd hh:mm')
            );
        }  
    }
    
];
export const editInlineData = [
    {
        teamName: '交通号',
        courtName: '城乡',
        scenesType:'路段',
        scenesScore:'80',
        createTime: '2017-11-21'
    },
    {
        teamName: '红旗三号',
        courtName: '高速赛场',
        scenesType:'场景',
        scenesScore:'100',
        createTime: '2017-11-22'
    },
    {
        teamName: '天龙一号',
        courtName: '城乡',
        scenesType:'路段',
        scenesScore:'70',
        createTime: '2017-11-23'
    }
];
const tableData = {
	editInlineData:editInlineData,
    editInlineAndCellColumn: editInlineAndCellColumn,
};


export default tableData;
