import {formatSeconds,replaceTime} from '../components/date.js';
export const editInlineAndCellColumn = [
	{
        title: '序号',
        type: 'index',
        width: 80,
        align: 'center'
    },
    {
        title: '申请公司',
        align: 'center',
        key: 'companyName',
    },
    {
        title: '测评等级',
        align: 'center',
        key: 'stadiumName',
    },
    {
        title: '测评车型',
        align: 'center',
        key: 'teamName',
    },
    {
        title: '用时时间',
        align: 'center',
        key: 'matchTime',
        render: function (h, params) {  
           if(this.row.matchTime){
        		
        		return h('div',   
            	formatSeconds(this.row.matchTime)
            );
        	}else{
        		return ""
        	}
        }  
    },
    {
        title: '测评日期',
        align: 'center',
        key: 'startTime',
        render: function (h, params) { 
        	if(this.row.startTime){
        		return h('div',   
            	replaceTime(this.row.startTime/1000)
            );
        	}else{
        		return ''
        	}
        
        }  
    },
    {
        title: '分数',
        align: 'center',
        width: 100,
        key: 'totalScore',
        render:function(){
        	return this.row.totalScore +"分"
        }
    },
    {
        title: '操作',
        align: 'center',
        width: 100,
        key: 'handle',
        handle: ['detail']
    }
];

const tableData = {
    editInlineAndCellColumn: editInlineAndCellColumn,
};


export default tableData;
