import { defineStore } from "pinia";

export const useStateStore = defineStore('state', {
    state: () => {
        return {
            isShowNetworkTip: false,
            netWorkTipCount: 0,
            truckMonitorMsg: {
                visible: false
            },
            loginAck: {},
            loginForm: null,
            gps: 4,
            wifi: 0,
            currentTime: new Date()
        }
    },
    getters: {
        getLoginAck() {
            return this.loginAck
        },
        getSock() {
            return this.socket
        }
    },
    actions: {
        dealNetworkTip(data) {
            if (this.truckMonitorMsg.visible) return
            let {type, count} = data
            this.isShowNetworkTip = type
            this.netWorkTipCount = count || 0
        },
        setTruckMonitor(data) {
            this.truckMonitorMsg = data
        },
        setLoginForm(data) {
            this.loginForm = data
            window.localStorage.setItem(`${location.host}loginForm`, JSON.stringify(data))
        },
        setData(name, data) {
            this[name] = data
        }
    }
})