import Worker from './worker/index'
import Socket from './socket/index'
import IndexDB from './indexDB/IndexDB'

export default class IndexRoot {
    constructor() {
        this.worker = null
        this.sock = null
        this.indexDB = null
    }

    init() {
        const self = this
        return new Promise((resolve) => {
            let worker = new Worker(this)
            let indexDB = new IndexDB(this)

            this.worker = worker
            this.indexDB = indexDB
            let sock = new Socket(this)
            sock.getConnection().then(socket => {
                self.sock = socket
                resolve(socket)
            })
        })
    }

    destroyData() {
        this.worker.destroyData()
    }
}