import { defineStore } from "pinia";

export const useMapStore = defineStore('map', {
    state: () => {
        return {
            map: [], // 地图管理图层
            mapControlAck: {}, // 地图设置回复
            roughnessFileAck: null, // 地图不平整度文件列表
            lanenode: null, 
            lane: null, 
            runablearea: null, 
            centerline: null, 
            obstacles: null, // 障碍物图层
            diggingworkarea: null, 
            dumparea: null, 
            barricade: null, 
            stationarea: null,
            parkspot: null, 
            staticobjs: null,
            electronicFence: null,
            obstacleData: null, // obc
            avoidancePath: null, // 绕障路径
            morepoint: null, // 单机循迹单路径多点
            morepath: null, // 单机循迹多路径
            nextPathinfo: null, 
            currPathinfo: null,
            nextPathAvailable: null, // 下一段路路权
            currPathAvailable: null, // 当前路径路权
            dynamicPathinfo: null, // 车辆动态路权信息
            stopPoint: null, // 停车点
        }
    },
    actions: {
        setData(name, data) {
            this[name] = data
        }
    }
})