import { defineStore } from "pinia";
const MAX_BYTES = 1048576

export const useVehicleStore = defineStore('vehicle', {
    state: () => {
        return {
            isError: 'normal',
            pattern: 0, // 0-有人驾驶；1-有安全员无人驾驶；2-无安全员无人驾驶模式
            softDrivingPattern:0,//软件层面的驾驶模式，用于逻辑判断，0-有人驾驶；其他-无人驾驶
            debuginfo: {},
            statusinfo: {}, // 车辆状态信息
            vehicleBasic: {},
            vehicleErrorList: [],
            pairinfo: {}, // 车辆关系配对表
            commandInfo: null, // 车辆提示信息（左下角）
            tipInfo: null, // 车辆弹框信息
            paraminfo: {}, // 车辆全局参数信息
            debugack: null, // debug
            patternAck: null, // 车辆模式切换
            retranTimer: null, // 车辆任务重传定时器消息
            singleTrackAck: {}, // 设置单机循迹
            product: null,
            infoPop: [], // 弹框确认信息，逐个显示，点击确定或取消后，才显示下一个,
            basicinfo: {}, // 基本数据信息
            light: {}, // 灯光
            safe: {}, // 安全设置
            controlInfo: {}, // 启动设置参数
            settingAck: null, // 设置返回结果
            terminal: [], // 终端对应关系列表
            terminalDetails: {}, // 终端内容列表
            ignoreObstaclesAck: null, // 忽略障碍物回复
            positioninfo: [], // 推送实时车辆信息
            currentBasic: {},
            safeObj: {},
            trajObj: {},
            vehiclesPositioninfo: [], // 车辆位置信息
            deleteVehicles: [], // 下线的车辆
            currentLoadthread: null,
            logSwitch: false, // log日志开关
            loadSwitch: false, // 空车转载开关
        }
    },
    getters: {
        getVehicleBasic() {
            return this.vehicleBasic
        },
        getVehicleError() {
            return this.isError
        },
        getVehicleDebug() {
            return this.debuginfo
        },
        getCurrentBasic() {
            return this.currentBasic
        },
        getCommand() {
            return this.commandInfo
        },
        getPositionInfo() {
            return this.positioninfo
        },
        getVehiclesPositionInfo() {
            return this.vehiclesPositioninfo
        },
        getSafeObj() {
            return this.safeObj
        },
        getTrajObj() {
            return this.trajObj
        },
        getDeleteVehicles() {
            return this.deleteVehicles
        }
    },
    actions: {
        setData(name, data) {
            this[name] = data
        },
        dealErrorCode(data) {
            if (data.length) {
                let isError = data.find(item => item.errLevel === 0)
                this.isError = isError ? 'fault' : 'warning'
            } else {
                this.isError = 'normal'
            }
            this.vehicleErrorList = data
        },
        dealParaminfo(data) {
            const {deviceId, deviceType, loadThread, logSwitch, loadSwitch} = data
            // this.currentDeviceID = deviceId
            // this.currentDevicetype = deviceType
            this.currentLoadthread = loadThread
            this.logSwitch = logSwitch
            this.loadSwitch = loadSwitch
        },
        dealInfoPop(data) {
            let {uuid} = data
            let index = this.infoPop.findIndex(item => item.uuid === uuid)
            index < 0 && this.infoPop.push(data)
        },
        splitInfoPop() {
            this.infoPop.splice(0, 1)
        },
        dealTerminalAck(data) {
            const {type, value} = data
            if (!this.terminalDetails[type]) {
                this.terminalDetails = Object.assign({}, this.terminalDetails, {
                    [type]: value
                })
            } else {
                let bytes = new Blob([this.terminalDetails[type]]).size
                if (bytes > MAX_BYTES) {
                    let currentResult = this.terminalDetails[type].split('\n')
                    let half = Math.floor(currentResult.length / 2)
                    currentResult.splice(0, half)
                    this.terminalDetails[type] = currentResult.join('\n')
                }
                if (this.terminalDetails[type].includes(value)) return
                
                let result = this.terminalDetails[type] + value
                this.terminalDetails = Object.assign({}, this.terminalDetails, {
                    [type]: result
                })
            }
        },
        setBasicInfo(data) {
            const {oil, isOil, tire0, tire1, tire2, tire3, tire4, tire5, roll, pitch} = data
            this.vehicleBasic = {oil, isOil, tire0, tire1, tire2, tire3, tire4, tire5, roll: roll.toFixed(1), pitch: pitch.toFixed(1)}
        }
    }
})