const VEHICLE_IMAGE = {
    1: 'exca_planform',
    20: 'exca_planform',
    21: 'exca_planform',
    2: 'dumpMachine',
    30: 'dumpMachine',
    31: 'dumpMachine',
    3: 'manCar',
    40: 'manCar',
    41: 'wateringCar',
    42: 'manCar',
    43: 'grader'
}

function dealSafe(safe, vehicleType, vehicleLatitude, vehicleLongtitude) {
    const { enable, data } = safe
    if (!enable) return

    const safeType = [1, 20, 21].includes(vehicleType) ? 'circle' : 'rectangle'
    const dealedData = []

    for (let i = 0; i < data.length; i++) {
        let item = data[i]
        if (safeType === 'rectangle') {
            let [lngs, lats] = item
            let datas = []
            lngs.forEach((item, index) => datas.push([lats[index], item]))
            dealedData.push(datas)
        }
    }
    safe = Object.assign({}, safe, {
        dealedData,
        vehicleLatitude,
        vehicleLongtitude,
        vehicleType
    })
    return safe
}

function dealSafeDiff(preSafe, safe, vehicleType, vehicleLatitude, vehicleLongtitude) {
    let {enable, data} = safe
    let {enable: preEnable, data: preData} = preSafe
    if (enable === preEnable && enable === false) return

    if (enable === false) return safe

    if (data.length !== preData.length) return dealSafe(safe, vehicleType, vehicleLatitude, vehicleLongtitude)

    let isDiff = false
    for (let i = 0; i < data.length; i++) {
        let item = data[i]
        let preItem = preData[i]
        if (item.toString() != preItem.toString()) {
            isDiff = true
            break
        }
    }
    if (isDiff) return dealSafe(safe, vehicleType, vehicleLatitude, vehicleLongtitude)
}

function dealTraj(traj, vehicleType, vehicleLatitude, vehicleLongtitude) {
    if (!traj) return
    let { trajPath, radius } = traj
    // if ((!trajPath || !trajPath.length) && ![1, 20, 21].includes(vehicleType) && !radius) return
    if([1, 20, 21].includes(vehicleType) && radius) return

    if (![1, 20, 21].includes(vehicleType)) {
        if(!trajPath || !trajPath.length) return;
        let datas = []
        trajPath.forEach(item => {
            let [lon, lat] = item
            datas.push([lat, lon])
        })
        traj['dealedData'] = datas
    }
    traj = Object.assign({}, traj, {
        vehicleLatitude,
        vehicleLongtitude,
        vehicleType
    })
    return traj
}

function dealTrjaDiff(preTraj, traj, vehicleType, vehicleLatitude, vehicleLongtitude, preBasic) {
    let {radius, trajPath} = traj
    let {radius: preRadius, trajPath: preTrajPath} = preTraj
    // if (preRadius === radius && radius === 0) return

    if (!preTrajPath) return
    if (preTrajPath.length === trajPath.length && trajPath.length === 0) return

    if ([1, 20, 21].includes(vehicleType)) {
        if (preBasic.vehicleLatitude == vehicleLatitude && preBasic.vehicleLongtitude == vehicleLongtitude && preRadius == radius) return

        return traj
    }

    if (trajPath.toString() == preTrajPath.toString()) return

    return dealTraj(traj, vehicleType, vehicleLatitude, vehicleLongtitude)
}

function dealDiffBasic(preBasic, basic, deviceId) {
    let {vehicleType, vehicleLoad, vehicleLatitude, vehicleLongtitude, vehicleHeading, vehicleID } = basic
    if (vehicleID === deviceId) return false

    let isSame = vehicleType === preBasic.vehicleType
                && vehicleLoad === preBasic.vehicleLoad
                && vehicleLatitude === preBasic.vehicleLatitude
                && vehicleLongtitude === preBasic.vehicleLongtitude
                && vehicleHeading === preBasic.vehicleHeading
    return isSame
}

self.onmessage = function({data}) {
    let gps = 4, currentBasic = null
    try {
        const {type, msg, deviceId, pre} = data
        let safeObj = {}, trajObj = {}, vehicles = []
        for (let i = 0; i < msg.length; i++) {
            let item = msg[i]
            const { basic, safe, traj } = item
            const { vehicleType, vehicleLoad, vehicleLatitude, vehicleLongtitude, vehicleHeading, vehicleID, status } = basic

            let image = null
            if ([0, 11, 10, 15].includes(vehicleType)) {
                image = vehicleLoad > 10 ? 'heavyTruck1' : 'emptyTruck1'
                // 故障状态
                if (status == 17) image += 'fault'
            } else {
                image = VEHICLE_IMAGE[vehicleType]
            }
            basic['image'] = image

            let preVehicle = pre.find(p => p.basic.vehicleID === vehicleID)
            let isSame = false, safeResult, trajResult
            if (preVehicle) {
                let {basic: preBasic, safe: preSafe, traj: preTraj} = preVehicle
                safeResult = dealSafeDiff(preSafe, safe, vehicleType, vehicleLatitude, vehicleLongtitude,)
                trajResult = dealTrjaDiff(preTraj, traj, vehicleType, vehicleLatitude, vehicleLongtitude, preBasic)
                isSame = dealDiffBasic(preBasic, basic, deviceId)
            } else {
                safeResult = dealSafe(safe, vehicleType, vehicleLatitude, vehicleLongtitude, vehicleID)
                trajResult = dealTraj(traj, vehicleType, vehicleLatitude, vehicleLongtitude, vehicleID)
                isSame = false
            }
            if (safeResult) safeObj[vehicleID] = safeResult
            if (trajResult) trajObj[vehicleID] = trajResult
            if (!isSame) vehicles.push(basic)

            if (vehicleID === deviceId) {
                gps = basic.gps
                currentBasic = basic
            }
        }
        
        self.postMessage({type, vehicles, safeObj, trajObj, gps, currentBasic})
        data = null
        currentBasic = null
        safeObj = {}
        trajObj = {}
        vehicles = []
    } catch(err) {
        console.log(err)
    }
}