function deallnglatData (data) {
    if (!data) return []
    if (typeof data === 'string') {
        data = JSON.parse(data)
    }

    let result = []
    for (let i = 0, length = data.length; i < length; i++) {
        let item = data[i]
        let dealed = [item[1], item[0]]
        result.push(dealed)
    }
    return result
}

function dealObstacleData(obstacle) {
    for (let i = 0; i < obstacle.length; i++) {
        let originCoordinate = JSON.parse(JSON.stringify(obstacle[i].coordinate))
        let dealedData = deallnglatData(obstacle[i].coordinate)
        obstacle[i].coordinate = dealedData
        obstacle[i].ocoordinate = originCoordinate
    }
    return obstacle
}

function dealPointData(msg) {
    let dealPath = []
    for (let i = 0; i < msg.length; i++) {
        let {color, coor} = msg[i]
        let result = deallnglatData(coor)
        dealPath.push({color, coor: result})
    }
    return dealPath
}

function dealMorePath (msg) {
    let {color, coor} = msg, paths = []
    for (let i = 0; i < coor.length; i++) {
        let result = deallnglatData(coor[i])
        paths.push({color, coor: result})
    }
    return paths
}

function dealDynamicPath (msg) {
    let {color, path} = msg, paths = []
    let result = deallnglatData(path)
    paths.push({color, path: result})
    return paths
}

self.onmessage = function({data}) {
    try {
        const {name, msg} = data
        let dealedData = null
        if (name === 'obstacle') {
            dealedData = dealObstacleData(msg)
        } else if (name === 'morepoint') {
            dealedData = dealPointData(msg)
        } else if (name === 'morePath') {
            dealedData = dealMorePath(msg)
        } else if (name === 'dynamicPathinfo') {
            dealedData = dealDynamicPath(msg)
        } else {
            dealedData = deallnglatData(msg)
        }
        self.postMessage({name, dealedData, originData: msg})
        data = null
    } catch(error) {
        console.log(error)
    }
}