/**
 * 关于deck.gl的二次封装，由于很多功能使用起来不方便，因此进行二次封装
 * gaoxf
 */
import { Deck } from '@deck.gl/core';
import { GeoJsonLayer } from '@deck.gl/layers';
import {ScenegraphLayer} from '@deck.gl/mesh-layers';
export default class DeckNew{
    constructor(props){
        this.deck=new Deck({...props,_animation:true})
        this.initProps={initialViewState:props.initialViewState};
        this.mapLayers=[];
        this.markerLayers=[];
        this.createGeoJsonLayer=this.createGeoJsonLayer.bind(this);
    }
    createGeoJsonLayer(result,attribute,layerName){
        let layer = new GeoJsonLayer({
            id: layerName,
            data: this.convert(result),
            stroked: true,
            filled: true,
            extruded: false,
            wireframe: true,
            getElevation: 0,
            pickable: true,
            ...attribute,
        });
        this.removeLayer('map',layerName)
        this.mapLayers.push(layer)
        this.layerSort()
        this.deck.setProps({
            layers:[...this.markerLayers,...this.mapLayers]
        })
    }
    createCarModel(data,layerName){
        const layer = new ScenegraphLayer({
            id: layerName,
            data,
            pickable: true,
            scenegraph: 'https://raw.githubusercontent.com/KhronosGroup/glTF-Sample-Models/master/2.0/BoxAnimated/glTF-Binary/BoxAnimated.glb',
            getPosition: d => d.coordinates,
            // getOrientation: d => [0, Math.random() * 180, 90],
            // _animations: {
            //   '*': {speed: 5}
            // },
            sizeScale: 10,
            _lighting: 'pbr',
            getTranslation:[0,0,5],
            getOrientation:f=>{
                // console.log(f)
                return [0,f.rotate*180/Math.PI,0]
            }
          });
          this.removeLayer('marker',layerName)
          this.markerLayers.push(layer)
          this.deck.setProps({
            layers:[...this.markerLayers,...this.mapLayers]
        })
    }
    setRotation(rotate){
        this.initProps.viewState.bearing=rotate;
        this.deck.setProps({...this.initProps})
    }
    flyTo(coor){
        this.initProps.initialViewState.longitude=coor[0];
        this.initProps.initialViewState.latitude=coor[1];
        this.initProps.initialViewState.zoom=18
        this.deck.setProps({initialViewState:{latitude: document.location.mapCenter[0],
            longitude: document.location.mapCenter[1],
            zoom: 18,
            maxZoom: 20,
            pitch: 0,
            bearing: 0}})
    }
    //根据页面中图层的顺序排序
    layerSort() {
        //图层的顺序
        let obj = ['lane','centerLine','electronicFence','obstacles','staticobjs','dumparea','parkspot','barricade', 'diggingworkarea', 'runablearea']
        let newArray = []
        obj.forEach(item => {
            this.mapLayers.forEach(m => {
                if(item==m.id){
                    newArray.push(m)
                }
            })
        })
        this.mapLayers=newArray.reverse();
    }
    //根据图层名字从图层数组中移除对应图层
    removeLayer(type,layerName){
        if(type=='marker'){
            this.markerLayers.forEach((item,index)=>{
                if(item.id==layerName){
                    this.markerLayers.splice(index,1)
                }
            })
        }else{
            this.mapLayers.forEach((item,index)=>{
                if(item.id==layerName){
                    this.mapLayers.splice(index,1)
                }
            })
        }
    }
    remove(){
        this.deck.setProps({
            layers:[]
        })
    }
    convert(obj) {
        let { features } = obj;
        for (let i = 0; i < features.length; i++) {
            let { geometry } = features[i];
            let { coordinates, type } = geometry;
            for (let j = 0; j < coordinates.length; j++) {
                if (type == "Polygon") {
                    for (let k = 0; k < coordinates[j].length; k++) {
                        if (coordinates[j][k].length > 2) {
                            coordinates[j][k] = coordinates[j][k].slice(0, 2)
                        }
                    }
                } else {
                    if (coordinates[j].length > 2) {
                        coordinates[j] = coordinates[j].slice(0, 2)
                    }
                }
            }
    
        }
        return obj
    }
    convertColor(color,opacity) {
        if(color.indexOf('rgba')>-1){
            let colors=color.replace('rgba','').replace('(','').replace(')','').split(',').map(m=>parseInt(m))
            return [...colors.slice(0,3),opacity?opacity*225:225]
        }
        return [...color.match(/[0-9a-f]{2}/g).map(x => parseInt(x, 16)),opacity?opacity*225:225]
    }
}

